/*
 * Globalize Culture pt-BR
 *
 * http://github.com/jquery/globalize
 *
 * Copyright Software Freedom Conservancy, Inc.
 * Dual licensed under the MIT or GPL Version 2 licenses.
 * http://jquery.org/license
 *
 * This file was generated by the Globalize Culture Generator
 * Translation: bugs found in this file need to be fixed in the generator
 */

(function( window, undefined ) {

var Globalize;

if ( typeof require !== "undefined" &&
	typeof exports !== "undefined" &&
	typeof module !== "undefined" ) {
	// Assume CommonJS
	Globalize = require( "globalize" );
} else {
	// Global variable
	Globalize = window.Globalize;
}

Globalize.addCultureInfo( "pt-BR", "default", {
	name: "pt-BR",
	englishName: "Portuguese (Brazil)",
	nativeName: "Português (Brasil)",
	language: "pt",
	numberFormat: {
		",": ".",
		".": ",",
		"NaN": "NaN (Não é um número)",
		negativeInfinity: "-Infinito",
		positiveInfinity: "+Infinito",
		percent: {
			pattern: ["-n%","n%"],
			",": ".",
			".": ","
		},
		currency: {
			pattern: ["-$ n","$ n"],
			",": ".",
			".": ",",
			symbol: "R$"
		}
	},
	calendars: {
		standard: {
			days: {
				names: ["domingo","segunda-feira","terça-feira","quarta-feira","quinta-feira","sexta-feira","sábado"],
				namesAbbr: ["dom","seg","ter","qua","qui","sex","sáb"],
				namesShort: ["D","S","T","Q","Q","S","S"]
			},
			months: {
				names: ["janeiro","fevereiro","março","abril","maio","junho","julho","agosto","setembro","outubro","novembro","dezembro",""],
				namesAbbr: ["jan","fev","mar","abr","mai","jun","jul","ago","set","out","nov","dez",""]
			},
			AM: null,
			PM: null,
			eras: [{"name":"d.C.","start":null,"offset":0}],
			patterns: {
				d: "dd/MM/yyyy",
				D: "dddd, d' de 'MMMM' de 'yyyy",
				t: "HH:mm",
				T: "HH:mm:ss",
				f: "dddd, d' de 'MMMM' de 'yyyy HH:mm",
				F: "dddd, d' de 'MMMM' de 'yyyy HH:mm:ss",
				M: "dd' de 'MMMM",
				Y: "MMMM' de 'yyyy"
			}
		}
	}
});

}( this ));
(function() {
var merge = function(obj1, obj2) {
  var obj3 = {};
  for(var attrname in obj1){obj3[attrname] = obj1[attrname]; }
  for(var attrname in obj2){obj3[attrname] = obj2[attrname]; }
  return obj3;
}
var dict = {
  "box user": "Usuário",
  "filetype_box user": "Usuário",
  "html": "Arquivo HTML",
  "filetype_html": "Arquivo HTML",
  "wiki": "Wiki",
  "filetype_wiki": "Wiki",
  "webscraperwebpage": "Página da web",
  "filetype_webscraperwebpage": "Página da web",
  "image": "Imagem",
  "filetype_image": "Imagem",
  "folder": "Pasta",
  "filetype_folder": "Pasta",
  "txt": "Texto",
  "filetype_txt": "Texto",
  "zip": "Arquivo ZIP",
  "filetype_zip": "Arquivo ZIP",
  "olefile": "Arquivo OLE",
  "filetype_olefile": "Arquivo OLE",
  "gmailmessage": "Mensagem do Gmail",
  "filetype_gmailmessage": "Mensagem do Gmail",
  "pdf": "Arquivo PDF",
  "filetype_pdf": "Arquivo PDF",
  "swf": "Arquivo Flash",
  "filetype_swf": "Arquivo Flash",
  "xml": "Arquivo XML",
  "filetype_xml": "Arquivo XML",
  "vsd": "Visio",
  "filetype_vsd": "Visio",
  "svg": "SVG",
  "filetype_svg": "SVG",
  "svm": "Open Office",
  "filetype_svm": "Open Office",
  "rssitem": "Feed RSS",
  "filetype_rssitem": "Feed RSS",
  "doc": "Documento",
  "filetype_doc": "Documento",
  "docx": "Documento do Microsoft Word",
  "filetype_docx": "Documento do Microsoft Word",
  "xls": "Documento de planilha",
  "filetype_xls": "Documento de planilha",
  "ppt": "Documento de apresentação",
  "filetype_ppt": "Documento de apresentação",
  "video": "Vídeo",
  "filetype_video": "Vídeo",
  "saleforceitem": "Salesforce",
  "filetype_saleforceitem": "Salesforce",
  "dynamicscrmitem": "Dynamics CRM",
  "filetype_dynamicscrmitem": "Dynamics CRM",
  "salesforceitem": "Salesforce",
  "filetype_salesforceitem": "Salesforce",
  "odt": "Documento do Open Text",
  "filetype_odt": "Documento do Open Text",
  "lithiummessage": "Mensagem do Lithium",
  "filetype_lithiummessage": "Mensagem do Lithium",
  "lithiumthread": "Tópico da conversa do Lithium",
  "filetype_lithiumthread": "Tópico da conversa do Lithium",
  "lithiumboard": "Quadro de avisos do Lithium",
  "filetype_lithiumboard": "Quadro de avisos do Lithium",
  "lithiumcategory": "Categoria do Lithium",
  "filetype_lithiumcategory": "Categoria do Lithium",
  "lithiumcommunity": "Comunidade do Lithium",
  "filetype_lithiumcommunity": "Comunidade do Lithium",
  "people": "Usuário",
  "objecttype_people": "Usuário",
  "message": "Mensagem",
  "objecttype_message": "Mensagem",
  "feed": "Feed RSS",
  "objecttype_feed": "Feed RSS",
  "thread": "Tópico da conversa",
  "objecttype_thread": "Tópico da conversa",
  "file": "Arquivo",
  "objecttype_file": "Arquivo",
  "board": "Quadro de avisos",
  "objecttype_board": "Quadro de avisos",
  "category": "Categoria",
  "objecttype_category": "Categoria",
  "account": "Conta",
  "objecttype_account": "Conta",
  "annotation": "Nota",
  "objecttype_annotation": "Nota",
  "campaign": "Campanha",
  "objecttype_campaign": "Campanha",
  "case": "Caso",
  "objecttype_case": "Caso",
  "contact": "Contato",
  "objecttype_contact": "Contato",
  "contract": "Contrato",
  "objecttype_contract": "Contrato",
  "event": "Evento",
  "objecttype_event": "Evento",
  "email": "E-mail",
  "objecttype_email": "E-mail",
  "goal": "Objetivo",
  "objecttype_goal": "Objetivo",
  "incident": "Caso",
  "objecttype_incident": "Caso",
  "invoice": "Fatura",
  "objecttype_invoice": "Fatura",
  "lead": "Lead",
  "objecttype_lead": "Lead",
  "list": "Lista",
  "objecttype_list": "Lista de marketing",
  "solution": "Solução",
  "objecttype_solution": "Solução",
  "task": "Tarefa",
  "objecttype_task": "Tarefa",
  "user": "Usuário",
  "objecttype_user": "Usuário",
  "attachment": "Anexo",
  "objecttype_attachment": "Anexo",
  "casecomment": "Comentário do caso",
  "objecttype_casecomment": "Comentário do caso",
  "opportunity": "Oportunidade",
  "objecttype_opportunity": "Oportunidade",
  "opportunityproduct": "Produto de oportunidade",
  "objecttype_opportunityproduct": "Produto de oportunidade",
  "feeditem": "Chatter",
  "objecttype_feeditem": "Chatter",
  "feedcomment": "Chatter",
  "objecttype_feedcomment": "Chatter",
  "note": "Nota",
  "objecttype_note": "Nota",
  "product": "Produto",
  "objecttype_product": "Produto",
  "partner": "Parceiro",
  "objecttype_partner": "Parceiro",
  "queueitem": "Item da fila",
  "objecttype_queueitem": "Item da fila",
  "quote": "Cotação",
  "objecttype_quote": "Cotação",
  "salesliterature": "Literatura de vendas",
  "objecttype_salesliterature": "Literatura de vendas",
  "salesorder": "Pedido de vendas",
  "objecttype_salesorder": "Pedido de vendas",
  "service": "Serviço",
  "objecttype_service": "Serviço",
  "socialprofile": "Perfil social",
  "objecttype_socialprofile": "Perfil social",
  "kbdocumentation": "Documentação",
  "objecttype_kbdocumentation": "Documentação",
  "kbtechnicalarticle": "Documentação",
  "objecttype_kbtechnicalarticle": "Documentação",
  "kbsolution": "Solução",
  "objecttype_kbsolution": "Solução",
  "kbknowledgearticle": "Artigo da base de conhecimento",
  "objecttype_kbknowledgearticle": "Artigo da base de conhecimento",
  "kbattachment": "Anexo",
  "objecttype_kbattachment": "Anexo",
  "kbarticle": "Artigo",
  "objecttype_kbarticle": "Artigo",
  "kbarticlecomment": "Comentário do artigo",
  "objecttype_kbarticlecomment": "Comentário do artigo",
  "knowledgearticle": "Artigo da base de conhecimento",
  "objecttype_knowledgearticle": "Artigo da base de conhecimento",
  "topic": "Tópico",
  "objecttype_topic": "Tópico",
  "dashboard": "Painel de controle",
  "objecttype_dashboard": "Painel de controle",
  "contentversion": "Documento",
  "objecttype_contentversion": "Documento",
  "collaborationgroup": "Grupo de colaboração",
  "objecttype_collaborationgroup": "Grupo de colaboração",
  "spportal": "Portal",
  "filetype_spportal": "Portal",
  "spsite": "Site",
  "filetype_spsite": "Site",
  "spuserprofile": "Usuário do SharePoint",
  "filetype_spuserprofile": "Usuário do SharePoint",
  "sparea": "Área",
  "filetype_sparea": "Área",
  "spannouncement": "Anúncio",
  "filetype_spannouncement": "Anúncio",
  "spannouncementlist": "Anúncios",
  "filetype_spannouncementlist": "Anúncios",
  "spcontact": "Contato",
  "filetype_spcontact": "Contato",
  "spcontactlist": "Contatos",
  "filetype_spcontactlist": "Contatos",
  "spcustomlist": "Listas personalizadas",
  "filetype_spcustomlist": "Listas personalizadas",
  "spdiscussionboard": "Fórum de discussão",
  "filetype_spdiscussionboard": "Fórum de discussão",
  "spdiscussionboardlist": "Fóruns de discussão",
  "filetype_spdiscussionboardlist": "Fóruns de discussão",
  "spdocumentlibrarylist": "Biblioteca de documentos",
  "filetype_spdocumentlibrarylist": "Biblioteca de documentos",
  "spevent": "Evento",
  "filetype_spevent": "Evento",
  "speventlist": "Eventos",
  "filetype_speventlist": "Eventos",
  "spformlibrarylist": "Biblioteca de formulários",
  "filetype_spformlibrarylist": "Biblioteca de formulários",
  "spissue": "Problema",
  "filetype_spissue": "Problema",
  "spissuelist": "Problemas",
  "filetype_spissuelist": "Problemas",
  "splink": "Link",
  "filetype_splink": "Link",
  "splinklist": "Links",
  "filetype_splinklist": "Links",
  "sppicturelibrarylist": "Biblioteca de imagens",
  "filetype_sppicturelibrarylist": "Biblioteca de imagens",
  "spsurvey": "Pesquisa",
  "filetype_spsurvey": "Pesquisa",
  "spsurveylist": "Pesquisas",
  "filetype_spsurveylist": "Pesquisas",
  "sptask": "Tarefa",
  "filetype_sptask": "Tarefa",
  "sptasklist": "Tarefas",
  "filetype_sptasklist": "Tarefas",
  "spagenda": "Agenda",
  "filetype_spagenda": "Agenda",
  "spagendalist": "Agendas",
  "filetype_spagendalist": "Agendas",
  "spattendee": "Participante",
  "filetype_spattendee": "Participante",
  "spattendeelist": "Participantes",
  "filetype_spattendeelist": "Participantes",
  "spcustomgridlist": "Grades personalizadas",
  "filetype_spcustomgridlist": "Grades personalizadas",
  "spdecision": "Decisão",
  "filetype_spdecision": "Decisão",
  "spdecisionlist": "Decisões",
  "filetype_spdecisionlist": "Decisões",
  "spobjective": "Objetivo",
  "filetype_spobjective": "Objetivo",
  "spobjectivelist": "Objetivos",
  "filetype_spobjectivelist": "Objetivos",
  "sptextbox": "Caixa de texto",
  "filetype_sptextbox": "Caixa de texto",
  "sptextboxlist": "Lista de caixa de texto",
  "filetype_sptextboxlist": "Lista de caixa de texto",
  "spthingstobring": "Coisa para trazer",
  "filetype_spthingstobring": "Coisa para trazer",
  "spthingstobringlist": "Coisas para trazer",
  "filetype_spthingstobringlist": "Coisas para trazer",
  "sparealisting": "Lista de áreas",
  "filetype_sparealisting": "Lista de áreas",
  "spmeetingserie": "Série de reuniões",
  "filetype_spmeetingserie": "Série de reuniões",
  "spmeetingserielist": "Lista de séries de reuniões",
  "filetype_spmeetingserielist": "Lista de séries de reuniões",
  "spsitedirectory": "Item do diretório do site",
  "filetype_spsitedirectory": "Item do diretório do site",
  "spsitedirectorylist": "Diretório do site",
  "filetype_spsitedirectorylist": "Diretório do site",
  "spdatasource": "Fonte de dados",
  "filetype_spdatasource": "Fonte de dados",
  "spdatasourcelist": "Lista de fontes de dados",
  "filetype_spdatasourcelist": "Lista de fontes de dados",
  "splisttemplatecataloglist": "Galeria de modelos de lista",
  "filetype_splisttemplatecataloglist": "Galeria de modelos de lista",
  "spwebpartcataloglist": "Galeria de web parts",
  "filetype_spwebpartcataloglist": "Galeria de web parts",
  "spwebtemplatecataloglist": "Galeria de modelos do site",
  "filetype_spwebtemplatecataloglist": "Galeria de modelos do site",
  "spworkspacepagelist": "Páginas de espaço de trabalho",
  "filetype_spworkspacepagelist": "Páginas de espaço de trabalho",
  "spunknownlist": "Lista personalizada",
  "filetype_spunknownlist": "Lista personalizada",
  "spadministratortask": "Tarefa do administrador",
  "filetype_spadministratortask": "Tarefa do administrador",
  "spadministratortasklist": "Tarefas do administrador",
  "filetype_spadministratortasklist": "Tarefas do administrador",
  "spareadocumentlibrarylist": "Biblioteca de documentos de área",
  "filetype_spareadocumentlibrarylist": "Biblioteca de documentos de área",
  "spblogcategory": "Categoria do blog",
  "filetype_spblogcategory": "Categoria do blog",
  "spblogcategorylist": "Categorias do blog",
  "filetype_spblogcategorylist": "Categorias do blog",
  "spblogcomment": "Comentário do blog",
  "filetype_spblogcomment": "Comentário do blog",
  "spblogcommentlist": "Comentários do blog",
  "filetype_spblogcommentlist": "Comentários do blog",
  "spblogpost": "Postagem do blog",
  "filetype_spblogpost": "Postagem do blog",
  "spblogpostlist": "Postagens do blog",
  "filetype_spblogpostlist": "Postagens do blog",
  "spdataconnectionlibrarylist": "Biblioteca de conexões de dados",
  "filetype_spdataconnectionlibrarylist": "Biblioteca de conexões de dados",
  "spdistributiongroup": "Grupo de distribuição",
  "filetype_spdistributiongroup": "Grupo de distribuição",
  "spdistributiongrouplist": "Grupos de distribuição",
  "filetype_spdistributiongrouplist": "Grupos de distribuição",
  "spipfslist": "Servidores de formulários do InfoPath",
  "filetype_spipfslist": "Servidores de formulários do InfoPath",
  "spkeyperformanceindicator": "Indicador Chave de Desempenho",
  "filetype_spkeyperformanceindicator": "Indicador Chave de Desempenho",
  "spkeyperformanceindicatorlist": "Indicadores Chave de Desempenho",
  "filetype_spkeyperformanceindicatorlist": "Indicadores Chave de Desempenho",
  "splanguagesandtranslator": "Idiomas e tradutor",
  "filetype_splanguagesandtranslator": "Idiomas e tradutor",
  "splanguagesandtranslatorlist": "Idiomas e tradutores",
  "filetype_splanguagesandtranslatorlist": "Idiomas e tradutores",
  "spmasterpagescataloglist": "Galeria de Páginas Mestras",
  "filetype_spmasterpagescataloglist": "Galeria de Páginas Mestras",
  "spnocodeworkflowlibrarylist": "Bibliotecas de fluxo de trabalho sem código",
  "filetype_spnocodeworkflowlibrarylist": "Bibliotecas de fluxo de trabalho sem código",
  "spprojecttask": "Tarefa do projeto",
  "filetype_spprojecttask": "Tarefa do projeto",
  "spprojecttasklist": "Tarefas de projeto",
  "filetype_spprojecttasklist": "Tarefas de projeto",
  "sppublishingpageslibrarylist": "Biblioteca de páginas",
  "filetype_sppublishingpageslibrarylist": "Biblioteca de páginas",
  "spreportdocumentlibrarylist": "Biblioteca de documentos de relatório",
  "filetype_spreportdocumentlibrarylist": "Biblioteca de documentos de relatório",
  "spreportlibrarylist": "Biblioteca de relatórios",
  "filetype_spreportlibrarylist": "Biblioteca de relatórios",
  "spslidelibrarylist": "Biblioteca de slides",
  "filetype_spslidelibrarylist": "Biblioteca de slides",
  "sptab": "Guias",
  "filetype_sptab": "Guias",
  "sptablist": "Lista de guias",
  "filetype_sptablist": "Lista de guias",
  "sptranslationmanagementlibrarylist": "Biblioteca de gerenciamento de tradução",
  "filetype_sptranslationmanagementlibrarylist": "Biblioteca de gerenciamento de tradução",
  "spuserinformation": "Informações do usuário",
  "filetype_spuserinformation": "Informações do usuário",
  "spuserinformationlist": "Lista de informações do usuário",
  "filetype_spuserinformationlist": "Lista de informações do usuário",
  "spwikipagelibrarylist": "Biblioteca de páginas wiki",
  "filetype_spwikipagelibrarylist": "Biblioteca de páginas wiki",
  "spworkflowhistory": "Histórico do fluxo de trabalho",
  "filetype_spworkflowhistory": "Histórico do fluxo de trabalho",
  "spworkflowhistorylist": "Lista do histórico do fluxo de trabalho",
  "filetype_spworkflowhistorylist": "Lista do histórico do fluxo de trabalho",
  "spworkflowprocess": "Processo de fluxo de trabalho personalizado",
  "filetype_spworkflowprocess": "Processo de fluxo de trabalho personalizado",
  "spworkflowprocesslist": "Processos de fluxo de trabalho personalizados",
  "filetype_spworkflowprocesslist": "Processos de fluxo de trabalho personalizados",
  "sppublishingimageslibrarylist": "Biblioteca de imagens de publicação",
  "filetype_sppublishingimageslibrarylist": "Biblioteca de imagens de publicação",
  "spcirculation": "Circulação",
  "filetype_spcirculation": "Circulação",
  "spcirculationlist": "Circulações",
  "filetype_spcirculationlist": "Circulações",
  "spdashboardslibrarylist": "Biblioteca de painéis de controle",
  "filetype_spdashboardslibrarylist": "Biblioteca de painéis de controle",
  "spdataconnectionforperformancepointlibrarylist": "Biblioteca de conexões de dados do PerformancePoint",
  "filetype_spdataconnectionforperformancepointlibrarylist": "Biblioteca de conexões de dados do PerformancePoint",
  "sphealthreport": "Relatório de saúde",
  "filetype_sphealthreport": "Relatório de saúde",
  "sphealthreportlist": "Relatórios de saúde",
  "filetype_sphealthreportlist": "Relatórios de saúde",
  "sphealthrule": "Regra de saúde",
  "filetype_sphealthrule": "Regra de saúde",
  "sphealthrulelist": "Regras de saúde",
  "filetype_sphealthrulelist": "Regras de saúde",
  "spimedictionary": "Dicionário IME",
  "filetype_spimedictionary": "Dicionário IME",
  "spimedictionarylist": "Dicionários IME",
  "filetype_spimedictionarylist": "Dicionários IME",
  "spperformancepointcontent": "Conteúdo do PerformancePoint",
  "filetype_spperformancepointcontent": "Conteúdo do PerformancePoint",
  "spperformancepointcontentlist": "Conteúdos do PerformancePoint",
  "filetype_spperformancepointcontentlist": "Conteúdos do PerformancePoint",
  "spphonecallmemo": "Memorando de chamadas telefônicas",
  "filetype_spphonecallmemo": "Memorando de chamadas telefônicas",
  "spphonecallmemolist": "Memorandos de chamadas telefônicas",
  "filetype_spphonecallmemolist": "Memorandos de chamadas telefônicas",
  "sprecordlibrarylist": "Biblioteca de gravações",
  "filetype_sprecordlibrarylist": "Biblioteca de gravações",
  "spresource": "Recurso",
  "filetype_spresource": "Recurso",
  "spresourcelist": "Recursos",
  "filetype_spresourcelist": "Recursos",
  "spprocessdiagramslibrarylist": "Biblioteca de diagramas de processo",
  "filetype_spprocessdiagramslibrarylist": "Biblioteca de diagramas de processo",
  "spsitethemeslibrarylist": "Biblioteca de temas do site",
  "filetype_spsitethemeslibrarylist": "Biblioteca de temas do site",
  "spsolutionslibrarylist": "Biblioteca de soluções",
  "filetype_spsolutionslibrarylist": "Biblioteca de soluções",
  "spwfpublibrarylist": "Biblioteca de WFPUB",
  "filetype_spwfpublibrarylist": "Biblioteca de WFPUB",
  "spwhereabout": "Local",
  "filetype_spwhereabout": "Local",
  "spwhereaboutlist": "Locais",
  "filetype_spwhereaboutlist": "Locais",
  "spdocumentlink": "Link para um documento",
  "filetype_spdocumentlink": "Link para um documento",
  "spdocumentset": "Conjunto de documentos",
  "filetype_spdocumentset": "Conjunto de documentos",
  "spmicrofeedpost": "Postagem de microfeed",
  "filetype_spmicrofeedpost": "Postagem de microfeed",
  "spmicrofeedlist": "Microfeed",
  "filetype_spmicrofeedlist": "Microfeed",
  "splistfolder": "Pasta de lista",
  "filetype_splistfolder": "Pasta de lista",
  "Unknown": "Desconhecido",
  "And": "E",
  "Authenticating": "Autenticando {0} ...",
  "Clear": "Desmarcar {0}",
  "CompleteQuery": "Consulta completa",
  "Exclude": "Excluir {0}",
  "EnterTag": "Adicionar tag",
  "Next": "Próximo",
  "Last": "Último",
  "Link": "Link",
  "Or": "OU",
  "Previous": "Anterior",
  "QueryDidntMatchAnyDocuments": "Sua consulta não encontrou nenhum documento correspondente.",
  "QueryException": "Sua consulta tem um erro: {0}.",
  "Me": "Eu",
  "Remove": "Remover",
  "Search": "Pesquisar",
  "SearchFor": "Pesquisar por {0}",
  "ShareQuery": "Compartilhar consulta",
  "Preferences": "Preferências",
  "LinkOpeningSettings": "Configurações de abertura do link",
  "Reauthenticate": "Reautenticar {0}",
  "ResultsFilteringExpression": "Expressões de filtragem de resultados",
  "FiltersInYourPreferences": "Filtros em suas preferências",
  "Create": "Criar",
  "SearchIn": "Pesquisar em {0}",
  "Seconds": "em {0} segundo<pl>s</pl>",
  "ShowingResultsOf": "Resultado<pl>s</pl> {0}<pl>-{1}</pl> de {2}",
  "ShowingResultsOfWithQuery": "Resultado<pl>s</pl> {0}<pl>-{1}</pl> de {2}",
  "SwitchTo": "Mudar para {0}",
  "Unexclude": "Desfazer exclusão {0}",
  "ClearAllFilters": "Desmarcar todos os filtros",
  "SkipLogin": "Ignorar login",
  "LoginInProgress": "Login em andamento, aguarde ...",
  "Login": "Login",
  "GetStarted": "Introdução",
  "More": "Mais",
  "NMore": "{0} mais...",
  "Less": "Menos",
  "Settings": "Configurações",
  "Score": "Pontuação",
  "ScoreDescription": "A pontuação é calculada a partir do número de ocorrências, bem como a partir da posição no conjunto de resultados.",
  "Occurrences": "Ocorrências",
  "OccurrencesDescription": "Classifica pelo número de ocorrências, com valores que têm o maior número aparecendo em primeiro lugar.",
  "Label": "Rótulo",
  "Of": "de",
  "LabelDescription": "Classifica os valores do campo em ordem alfabética.",
  "Value": "Valor",
  "ValueDescription": "Classifica os valores do primeiro campo calculado",
  "AlphaAscending": "Valor crescente",
  "AlphaDescending": "Valor decrescente",
  "ChiSquare": "Qui-quadrado",
  "Nosort": "Sem classificação",
  "NosortDescription": "Não classificar os valores. Os valores serão retornados em uma ordem aleatória.",
  "RelativeFrequency": "Frequência relativa",
  "RelativeFrequencyDescription": "Classifica com base na frequência relativa dos valores. Valores menos comuns aparecerão mais altos.",
  "DateDistribution": "Distribuição de data",
  "Custom": "Personalizada",
  "CustomDescription": "Classifica com base em uma ordem personalizada",
  "ComputedField": "Campo calculado",
  "Ascending": "Crescente",
  "Descending": "Decrescente",
  "noResultFor": "Nenhum resultado para {0}",
  "autoCorrectedQueryTo": "A consulta foi corrigida automaticamente para {0}",
  "didYouMean": "Você quis dizer: {0}",
  "SuggestedResults": "Resultados sugeridos",
  "SuggestedQueries": "Consultas sugeridas",
  "MostRelevantItems": "Itens mais relevantes:",
  "AllItems": "Todos os itens:",
  "ShowLess": "Mostrar menos",
  "ShowMore": "Mostrar mais",
  "HideFacet": "Ocultar faceta",
  "ShowFacet": "Mostrar faceta",
  "AndOthers": "e {0} outro<pl>s</pl>",
  "Others": "{0} outro<pl>s</pl>",
  "MostRelevantPosts": "Postagens mais relevantes:",
  "CompleteThread": "Tópico completo:",
  "ShowCompleteThread": "Mostrar o tópico completo",
  "ShowOnlyTopMatchingPosts": "Mostrar somente as principais postagens correspondentes",
  "MostRelevantReplies": "Respostas mais relevantes:",
  "AllConversation": "Todas as conversas:",
  "ShowAllConversation": "Mostrar todas as conversas",
  "ShowAllReplies": "Mostrar todas as respostas",
  "ShowOnlyMostRelevantReplies": "Mostrar somente as respostas mais relevantes",
  "Close": "Fechar",
  "Open": "Abrir",
  "OpenInOutlookWhenPossible": "Abrir no Outlook (quando possível)",
  "AlwaysOpenInNewWindow": "Sempre abrir os resultados em uma nova janela",
  "Quickview": "Visualização rápida",
  "NoQuickview": "A Visualização rápida para este documento não está disponível",
  "ErrorReport": "Relatório de erros",
  "OopsError": "Algo deu errado no servidor.",
  "ProblemPersists": "Se o problema persistir entre em contato com o administrador.",
  "GoBack": "Voltar",
  "Reset": "Reiniciar",
  "Retry": "Tentar novamente",
  "MoreInfo": "Mais Informações",
  "Username": "Nome de usuário",
  "Password": "Senha",
  "PostedBy": "Postado por",
  "CannotConnect": "Não é possível conectar ao endereço do servidor.",
  "BadUserPass": "Nome de usuário e senha não correspondem.",
  "PleaseEnterYourCredentials": "Digite as suas credenciais para {0}.",
  "PleaseEnterYourSearchPage": "Digite a URL da página de pesquisa",
  "Collapse": "Recolher",
  "Collapsable": "Recolhível",
  "Expand": "Expandir",
  "Today": "Hoje",
  "Yesterday": "Ontem",
  "Tomorrow": "Amanhã",
  "Duration": "Duração: {0}",
  "IndexDuration": "Duração do índice: {0}",
  "ProxyDuration": "Duração do proxy: {0}",
  "ClientDuration": "Duração do cliente: {0}",
  "Unavailable": "Indisponível",
  "Reply": "Responder",
  "ReplyAll": "Responder a todos",
  "Forward": "Encaminhar",
  "From": "De",
  "Caption": "Legenda",
  "Expression": "Expressão",
  "Tab": "Guia",
  "Tabs": "Guias",
  "EnterExpressionName": "Digite o nome da expressão",
  "EnterExpressionToFilterWith": "Digite a expressão para filtrar os resultados",
  "SelectTab": "Selecionar guia",
  "SelectAll": "Selecionar tudo",
  "PageUrl": "URL da página de pesquisa",
  "ErrorSavingToDevice": "Erro ao salvar as informações para o seu dispositivo",
  "ErrorReadingFromDevice": "Erro ao ler as informações do seu dispositivo",
  "AppIntro": "Fale com um especialista de produto que possa responder suas dúvidas sobre a Coveo e ajudá-lo a decidir qual solução Coveo é adequada para você. Ou experimente uma demonstração ao vivo!",
  "TryDemo": "Experimente a demonstração",
  "ContactUs": "Entre em contato conosco",
  "NewToCoveo": "Novo para a Coveo?",
  "LetUsHelpGetStarted": "Vamos ajudá-lo a começar",
  "LikesThis": "{0} assim<sn>s</sn>.",
  "CannotConnectSearchPage": "Não é possível conectar à sua página de pesquisa",
  "AreYouSureDeleteFilter": "Você tem certeza que deseja excluir o filtro {0} com a expressão {1}",
  "OnlineHelp": "Ajuda online",
  "Done": "Concluído",
  "SaveFacetState": "Salvar este estado da faceta",
  "ClearFacetState": "Desmarcar estado da faceta",
  "DisplayingTheOnlyMessage": "Exibindo a única mensagem nesta conversa",
  "NoNetworkConnection": "Sem conexão de rede",
  "UnknownConnection": "Conexão desconhecida",
  "EthernetConnection": "Conexão de Ethernet",
  "WiFi": "Conexão de Wi-fi",
  "CELL": "Conexão de celular",
  "CELL_2G": "Conexão de celular 2G",
  "CELL_3G": "Conexão de celular 3G",
  "CELL_4G": "Conexão de celular 4G",
  "Relevance": "Relevância",
  "Date": "Data",
  "Amount": "Quantidade",
  "QueryExceptionNoException": "Sem exceção",
  "QueryExceptionInvalidSyntax": "Sintaxe inválida",
  "QueryExceptionInvalidCustomField": "Campo personalizado inválido",
  "QueryExceptionInvalidDate": "Data inválida",
  "QueryExceptionInvalidExactPhrase": "Frase exata inválida",
  "QueryExceptionInvalidDateOp": "Operador de data inválido",
  "QueryExceptionInvalidNear": "Operador NEAR inválido",
  "QueryExceptionInvalidWeightedNear": "NEAR ponderado inválido",
  "QueryExceptionInvalidTerm": "Termo inválido",
  "QueryExceptionTooManyTerms": "Muitos termos",
  "QueryExceptionWildcardTooGeneral": "Caractere curinga muito geral",
  "QueryExceptionInvalidSortField": "Campo de classificação inválido",
  "QueryExceptionInvalidSmallStringOp": "Operador de pequena cadeia de caracteres inválido",
  "QueryExceptionRequestedResultsMax": "Resultados máximos solicitados",
  "QueryExceptionAggregatedMirrorDead": "O espelho agregado está offline",
  "QueryExceptionAggregatedMirrorQueryTimeOut": "Tempo limite da consulta do espelho agregado",
  "QueryExceptionAggregatedMirrorInvalidBuildNumber": "Número de compilação inválido do espelho agregado",
  "QueryExceptionAggregatedMirrorCannotConnect": "Espelho agregado não pode se conectar",
  "QueryExceptionNotEnoughLeadingCharsWildcard": "Caractere curinga líder insuficiente",
  "QueryExceptionSecurityInverterNotFound": "Inversor de segurança não encontrado",
  "QueryExceptionSecurityInverterAccessDenied": "Acesso ao inversor de segurança negado",
  "QueryExceptionAggregatedMirrorCannotImpersonate": "O espelho agregado não pode representar",
  "QueryExceptionUnexpected": "Inesperado",
  "QueryExceptionAccessDenied": "Acesso negado",
  "QueryExceptionSuperUserTokenInvalid": "Token de superusuário inválido",
  "QueryExceptionSuperUserTokenExpired": "Token de superusuário expirado",
  "QueryExceptionLicenseQueriesExpired": "Consultas de licença expiradas",
  "QueryExceptionLicenseSuperUserTokenNotSupported": "Licença de token de superusuário não suportada",
  "QueryExceptionInvalidSession": "Sessão inválida",
  "QueryExceptionInvalidDocument": "Documento inválido",
  "QueryExceptionSearchDisabled": "Pesquisa desativada",
  "FileType": "Tipo de arquivo",
  "ShowAttachment": "Mostrar anexo",
  "OnFeed": "no feed de {0} .",
  "Author": "Autor",
  "NoTitle": "Sem título",
  "CurrentSelections": "Seleções atuais",
  "AllContent": "Todo o conteúdo",
  "CancelLastAction": "Cancelar a última ação",
  "SearchTips": "Dicas de pesquisa",
  "CheckSpelling": "Verifique a ortografia das suas palavras-chave.",
  "TryUsingFewerKeywords": "Tente usar palavras-chave menores, diferentes ou mais simples.",
  "SelectFewerFilters": "Selecione filtros menores para ampliar a sua pesquisa.",
  "Document": "Documento",
  "Time": "Hora",
  "StartDate": "Data de início",
  "StartTime": "Hora de início",
  "DurationTitle": "Duração",
  "UserQuery": "Consulta do usuário",
  "ShowUserActions": "Mostrar as ações do usuário",
  "NoData": "Nenhum dado disponível",
  "EventType": "Tipo de evento",
  "GoToFullSearch": "Pesquisa completa",
  "GoToEdition": "Painel de personalização",
  "RemoveContext": "Remover contexto",
  "BoxAttachToCase": "Anexar ao caso",
  "AttachToCase": "Anexar ao caso",
  "Attach": "Anexar",
  "Attached": "Anexado",
  "Detach": "Desanexar",
  "Details": "Detalhes",
  "AdditionalFilters": "Filtros adicionais",
  "SelectNonContextualSearch": "Remova o contexto do registro atual para ampliar a sua pesquisa",
  "CopyPasteToSupport": "Copie e cole esta mensagem para a equipe de Suporte da Coveo para obter mais informações.",
  "FollowQueryDescription": "Alerte-me quando ocorrer alterações nos resultados da pesquisa desta consulta.",
  "SearchAlerts_Panel": "Gerenciar alertas",
  "SearchAlerts_PanelDescription": "Visualizar e gerenciar os seus alertas de pesquisa.",
  "SearchAlerts_PanelNoSearchAlerts": "Você não possui assinaturas.",
  "SearchAlerts_Fail": "O serviço de Pesquisa de alertas não está disponível no momento.",
  "SearchAlerts_Type": "Tipo",
  "SearchAlerts_Content": "Conteúdo",
  "SearchAlerts_Actions": "Ação",
  "EmptyQuery": "<vazio>",
  "SearchAlerts_Type_followQuery": "Consulta",
  "SearchAlerts_Type_followDocument": "Item",
  "SearchAlerts_unFollowing": "Parar de seguir",
  "SearchAlerts_follow": "Seguir",
  "SearchAlerts_followed": "Seguido",
  "SearchAlerts_followQuery": "Seguir consulta",
  "Subscription_StopFollowingQuery": "Parar de seguir a consulta",
  "SearchAlerts_Frequency": "Quando",
  "SubscriptionsManageSubscriptions": "Gerenciar alertas",
  "SubscriptionsMessageFollowQuery": "Você receberá alertas quando a consulta <b>{0}</b> retornar itens novos ou atualizados.",
  "SubscriptionsMessageFollow": "Você receberá alertas se ocorrer alterações no item <b>{0}</b>.",
  "Expiration": "Expiração",
  "Monthly": "Mensal",
  "Daily": "Diário",
  "Monday": "Segunda-feira",
  "Tuesday": "Terça-feira",
  "Wednesday": "Quarta-feira",
  "Thursday": "Quinta-feira",
  "Friday": "Sexta-feira",
  "Saturday": "Sábado",
  "Sunday": "Domingo",
  "NextDay": "Próximo(a) {0}",
  "LastDay": "Último(a) {0}",
  "StartTypingCaseForSuggestions": "Descreva o seu problema para ver as possíveis soluções",
  "ExportToExcel": "Exportar para o Excel",
  "ExportToExcelDescription": "Exportar os resultados da pesquisa para o Excel",
  "CaseCreationNoResults": "Nenhuma solução recomendada foi encontrada",
  "SortBy": "Classificar por",
  "BoxCreateArticle": "Criar artigo",
  "Facets": "Facetas",
  "AdvancedSearch": "Pesquisa avançada",
  "Keywords": "Palavras-chave",
  "AllTheseWords": "Todas essas palavras",
  "ExactPhrase": "Esta frase exata",
  "AnyOfTheseWords": "Qualquer uma dessas palavras",
  "NoneOfTheseWords": "Nenhuma dessas palavras",
  "Anytime": "A qualquer momento",
  "InTheLast": "Nos últimos",
  "Days": "dias",
  "Months": "meses",
  "Month": "Mês",
  "Year": "Ano",
  "Between": "Entre",
  "Language": "Idioma",
  "Size": "Tamanho",
  "AtLeast": "pelo menos",
  "AtMost": "no máximo",
  "Contains": "contém",
  "DoesNotContain": "não contém",
  "Matches": "coincidências",
  "Bytes": "bytes",
  "card": "Cartão",
  "table": "Tabela",
  "ResultLinks": "Links do resultado",
  "EnableQuerySyntax": "Habilitar a sintaxe da consulta",
  "On": "Ativar",
  "Off": "Desativar",
  "Automatic": "Automático",
  "ResultsPerPage": "Resultados por página",
  "PreviousMonth": "Mês anterior",
  "NextMonth": "Próximo mês",
  "Title": "Título",
}
  var locales = String["locales"] || (String["locales"] = {});
  locales["pt-BR"] = merge(locales["pt-BR"], dict);
  String["toLocaleString"].call(this, { "pt-BR": dict });
  String["locale"] = "pt-BR";
  String["defaultLocale"] = "en";
  Globalize.culture("pt-BR")})();
if(!window.Coveo){window.Coveo = {};}
Coveo.setLanguageAfterPageLoaded = function() {
var merge = function(obj1, obj2) {
  var obj3 = {};
  for(var attrname in obj1){obj3[attrname] = obj1[attrname]; }
  for(var attrname in obj2){obj3[attrname] = obj2[attrname]; }
  return obj3;
}

var dict = {
  "box user": "Usuário",
  "filetype_box user": "Usuário",
  "html": "Arquivo HTML",
  "filetype_html": "Arquivo HTML",
  "wiki": "Wiki",
  "filetype_wiki": "Wiki",
  "webscraperwebpage": "Página da web",
  "filetype_webscraperwebpage": "Página da web",
  "image": "Imagem",
  "filetype_image": "Imagem",
  "folder": "Pasta",
  "filetype_folder": "Pasta",
  "txt": "Texto",
  "filetype_txt": "Texto",
  "zip": "Arquivo ZIP",
  "filetype_zip": "Arquivo ZIP",
  "olefile": "Arquivo OLE",
  "filetype_olefile": "Arquivo OLE",
  "gmailmessage": "Mensagem do Gmail",
  "filetype_gmailmessage": "Mensagem do Gmail",
  "pdf": "Arquivo PDF",
  "filetype_pdf": "Arquivo PDF",
  "swf": "Arquivo Flash",
  "filetype_swf": "Arquivo Flash",
  "xml": "Arquivo XML",
  "filetype_xml": "Arquivo XML",
  "vsd": "Visio",
  "filetype_vsd": "Visio",
  "svg": "SVG",
  "filetype_svg": "SVG",
  "svm": "Open Office",
  "filetype_svm": "Open Office",
  "rssitem": "Feed RSS",
  "filetype_rssitem": "Feed RSS",
  "doc": "Documento",
  "filetype_doc": "Documento",
  "docx": "Documento do Microsoft Word",
  "filetype_docx": "Documento do Microsoft Word",
  "xls": "Documento de planilha",
  "filetype_xls": "Documento de planilha",
  "ppt": "Documento de apresentação",
  "filetype_ppt": "Documento de apresentação",
  "video": "Vídeo",
  "filetype_video": "Vídeo",
  "saleforceitem": "Salesforce",
  "filetype_saleforceitem": "Salesforce",
  "dynamicscrmitem": "Dynamics CRM",
  "filetype_dynamicscrmitem": "Dynamics CRM",
  "salesforceitem": "Salesforce",
  "filetype_salesforceitem": "Salesforce",
  "odt": "Documento do Open Text",
  "filetype_odt": "Documento do Open Text",
  "lithiummessage": "Mensagem do Lithium",
  "filetype_lithiummessage": "Mensagem do Lithium",
  "lithiumthread": "Tópico da conversa do Lithium",
  "filetype_lithiumthread": "Tópico da conversa do Lithium",
  "lithiumboard": "Quadro de avisos do Lithium",
  "filetype_lithiumboard": "Quadro de avisos do Lithium",
  "lithiumcategory": "Categoria do Lithium",
  "filetype_lithiumcategory": "Categoria do Lithium",
  "lithiumcommunity": "Comunidade do Lithium",
  "filetype_lithiumcommunity": "Comunidade do Lithium",
  "people": "Usuário",
  "objecttype_people": "Usuário",
  "message": "Mensagem",
  "objecttype_message": "Mensagem",
  "feed": "Feed RSS",
  "objecttype_feed": "Feed RSS",
  "thread": "Tópico da conversa",
  "objecttype_thread": "Tópico da conversa",
  "file": "Arquivo",
  "objecttype_file": "Arquivo",
  "board": "Quadro de avisos",
  "objecttype_board": "Quadro de avisos",
  "category": "Categoria",
  "objecttype_category": "Categoria",
  "account": "Conta",
  "objecttype_account": "Conta",
  "annotation": "Nota",
  "objecttype_annotation": "Nota",
  "campaign": "Campanha",
  "objecttype_campaign": "Campanha",
  "case": "Caso",
  "objecttype_case": "Caso",
  "contact": "Contato",
  "objecttype_contact": "Contato",
  "contract": "Contrato",
  "objecttype_contract": "Contrato",
  "event": "Evento",
  "objecttype_event": "Evento",
  "email": "E-mail",
  "objecttype_email": "E-mail",
  "goal": "Objetivo",
  "objecttype_goal": "Objetivo",
  "incident": "Caso",
  "objecttype_incident": "Caso",
  "invoice": "Fatura",
  "objecttype_invoice": "Fatura",
  "lead": "Lead",
  "objecttype_lead": "Lead",
  "list": "Lista",
  "objecttype_list": "Lista de marketing",
  "solution": "Solução",
  "objecttype_solution": "Solução",
  "task": "Tarefa",
  "objecttype_task": "Tarefa",
  "user": "Usuário",
  "objecttype_user": "Usuário",
  "attachment": "Anexo",
  "objecttype_attachment": "Anexo",
  "casecomment": "Comentário do caso",
  "objecttype_casecomment": "Comentário do caso",
  "opportunity": "Oportunidade",
  "objecttype_opportunity": "Oportunidade",
  "opportunityproduct": "Produto de oportunidade",
  "objecttype_opportunityproduct": "Produto de oportunidade",
  "feeditem": "Chatter",
  "objecttype_feeditem": "Chatter",
  "feedcomment": "Chatter",
  "objecttype_feedcomment": "Chatter",
  "note": "Nota",
  "objecttype_note": "Nota",
  "product": "Produto",
  "objecttype_product": "Produto",
  "partner": "Parceiro",
  "objecttype_partner": "Parceiro",
  "queueitem": "Item da fila",
  "objecttype_queueitem": "Item da fila",
  "quote": "Cotação",
  "objecttype_quote": "Cotação",
  "salesliterature": "Literatura de vendas",
  "objecttype_salesliterature": "Literatura de vendas",
  "salesorder": "Pedido de vendas",
  "objecttype_salesorder": "Pedido de vendas",
  "service": "Serviço",
  "objecttype_service": "Serviço",
  "socialprofile": "Perfil social",
  "objecttype_socialprofile": "Perfil social",
  "kbdocumentation": "Documentação",
  "objecttype_kbdocumentation": "Documentação",
  "kbtechnicalarticle": "Documentação",
  "objecttype_kbtechnicalarticle": "Documentação",
  "kbsolution": "Solução",
  "objecttype_kbsolution": "Solução",
  "kbknowledgearticle": "Artigo da base de conhecimento",
  "objecttype_kbknowledgearticle": "Artigo da base de conhecimento",
  "kbattachment": "Anexo",
  "objecttype_kbattachment": "Anexo",
  "kbarticle": "Artigo",
  "objecttype_kbarticle": "Artigo",
  "kbarticlecomment": "Comentário do artigo",
  "objecttype_kbarticlecomment": "Comentário do artigo",
  "knowledgearticle": "Artigo da base de conhecimento",
  "objecttype_knowledgearticle": "Artigo da base de conhecimento",
  "topic": "Tópico",
  "objecttype_topic": "Tópico",
  "dashboard": "Painel de controle",
  "objecttype_dashboard": "Painel de controle",
  "contentversion": "Documento",
  "objecttype_contentversion": "Documento",
  "collaborationgroup": "Grupo de colaboração",
  "objecttype_collaborationgroup": "Grupo de colaboração",
  "spportal": "Portal",
  "filetype_spportal": "Portal",
  "spsite": "Site",
  "filetype_spsite": "Site",
  "spuserprofile": "Usuário do SharePoint",
  "filetype_spuserprofile": "Usuário do SharePoint",
  "sparea": "Área",
  "filetype_sparea": "Área",
  "spannouncement": "Anúncio",
  "filetype_spannouncement": "Anúncio",
  "spannouncementlist": "Anúncios",
  "filetype_spannouncementlist": "Anúncios",
  "spcontact": "Contato",
  "filetype_spcontact": "Contato",
  "spcontactlist": "Contatos",
  "filetype_spcontactlist": "Contatos",
  "spcustomlist": "Listas personalizadas",
  "filetype_spcustomlist": "Listas personalizadas",
  "spdiscussionboard": "Fórum de discussão",
  "filetype_spdiscussionboard": "Fórum de discussão",
  "spdiscussionboardlist": "Fóruns de discussão",
  "filetype_spdiscussionboardlist": "Fóruns de discussão",
  "spdocumentlibrarylist": "Biblioteca de documentos",
  "filetype_spdocumentlibrarylist": "Biblioteca de documentos",
  "spevent": "Evento",
  "filetype_spevent": "Evento",
  "speventlist": "Eventos",
  "filetype_speventlist": "Eventos",
  "spformlibrarylist": "Biblioteca de formulários",
  "filetype_spformlibrarylist": "Biblioteca de formulários",
  "spissue": "Problema",
  "filetype_spissue": "Problema",
  "spissuelist": "Problemas",
  "filetype_spissuelist": "Problemas",
  "splink": "Link",
  "filetype_splink": "Link",
  "splinklist": "Links",
  "filetype_splinklist": "Links",
  "sppicturelibrarylist": "Biblioteca de imagens",
  "filetype_sppicturelibrarylist": "Biblioteca de imagens",
  "spsurvey": "Pesquisa",
  "filetype_spsurvey": "Pesquisa",
  "spsurveylist": "Pesquisas",
  "filetype_spsurveylist": "Pesquisas",
  "sptask": "Tarefa",
  "filetype_sptask": "Tarefa",
  "sptasklist": "Tarefas",
  "filetype_sptasklist": "Tarefas",
  "spagenda": "Agenda",
  "filetype_spagenda": "Agenda",
  "spagendalist": "Agendas",
  "filetype_spagendalist": "Agendas",
  "spattendee": "Participante",
  "filetype_spattendee": "Participante",
  "spattendeelist": "Participantes",
  "filetype_spattendeelist": "Participantes",
  "spcustomgridlist": "Grades personalizadas",
  "filetype_spcustomgridlist": "Grades personalizadas",
  "spdecision": "Decisão",
  "filetype_spdecision": "Decisão",
  "spdecisionlist": "Decisões",
  "filetype_spdecisionlist": "Decisões",
  "spobjective": "Objetivo",
  "filetype_spobjective": "Objetivo",
  "spobjectivelist": "Objetivos",
  "filetype_spobjectivelist": "Objetivos",
  "sptextbox": "Caixa de texto",
  "filetype_sptextbox": "Caixa de texto",
  "sptextboxlist": "Lista de caixa de texto",
  "filetype_sptextboxlist": "Lista de caixa de texto",
  "spthingstobring": "Coisa para trazer",
  "filetype_spthingstobring": "Coisa para trazer",
  "spthingstobringlist": "Coisas para trazer",
  "filetype_spthingstobringlist": "Coisas para trazer",
  "sparealisting": "Lista de áreas",
  "filetype_sparealisting": "Lista de áreas",
  "spmeetingserie": "Série de reuniões",
  "filetype_spmeetingserie": "Série de reuniões",
  "spmeetingserielist": "Lista de séries de reuniões",
  "filetype_spmeetingserielist": "Lista de séries de reuniões",
  "spsitedirectory": "Item do diretório do site",
  "filetype_spsitedirectory": "Item do diretório do site",
  "spsitedirectorylist": "Diretório do site",
  "filetype_spsitedirectorylist": "Diretório do site",
  "spdatasource": "Fonte de dados",
  "filetype_spdatasource": "Fonte de dados",
  "spdatasourcelist": "Lista de fontes de dados",
  "filetype_spdatasourcelist": "Lista de fontes de dados",
  "splisttemplatecataloglist": "Galeria de modelos de lista",
  "filetype_splisttemplatecataloglist": "Galeria de modelos de lista",
  "spwebpartcataloglist": "Galeria de web parts",
  "filetype_spwebpartcataloglist": "Galeria de web parts",
  "spwebtemplatecataloglist": "Galeria de modelos do site",
  "filetype_spwebtemplatecataloglist": "Galeria de modelos do site",
  "spworkspacepagelist": "Páginas de espaço de trabalho",
  "filetype_spworkspacepagelist": "Páginas de espaço de trabalho",
  "spunknownlist": "Lista personalizada",
  "filetype_spunknownlist": "Lista personalizada",
  "spadministratortask": "Tarefa do administrador",
  "filetype_spadministratortask": "Tarefa do administrador",
  "spadministratortasklist": "Tarefas do administrador",
  "filetype_spadministratortasklist": "Tarefas do administrador",
  "spareadocumentlibrarylist": "Biblioteca de documentos de área",
  "filetype_spareadocumentlibrarylist": "Biblioteca de documentos de área",
  "spblogcategory": "Categoria do blog",
  "filetype_spblogcategory": "Categoria do blog",
  "spblogcategorylist": "Categorias do blog",
  "filetype_spblogcategorylist": "Categorias do blog",
  "spblogcomment": "Comentário do blog",
  "filetype_spblogcomment": "Comentário do blog",
  "spblogcommentlist": "Comentários do blog",
  "filetype_spblogcommentlist": "Comentários do blog",
  "spblogpost": "Postagem do blog",
  "filetype_spblogpost": "Postagem do blog",
  "spblogpostlist": "Postagens do blog",
  "filetype_spblogpostlist": "Postagens do blog",
  "spdataconnectionlibrarylist": "Biblioteca de conexões de dados",
  "filetype_spdataconnectionlibrarylist": "Biblioteca de conexões de dados",
  "spdistributiongroup": "Grupo de distribuição",
  "filetype_spdistributiongroup": "Grupo de distribuição",
  "spdistributiongrouplist": "Grupos de distribuição",
  "filetype_spdistributiongrouplist": "Grupos de distribuição",
  "spipfslist": "Servidores de formulários do InfoPath",
  "filetype_spipfslist": "Servidores de formulários do InfoPath",
  "spkeyperformanceindicator": "Indicador Chave de Desempenho",
  "filetype_spkeyperformanceindicator": "Indicador Chave de Desempenho",
  "spkeyperformanceindicatorlist": "Indicadores Chave de Desempenho",
  "filetype_spkeyperformanceindicatorlist": "Indicadores Chave de Desempenho",
  "splanguagesandtranslator": "Idiomas e tradutor",
  "filetype_splanguagesandtranslator": "Idiomas e tradutor",
  "splanguagesandtranslatorlist": "Idiomas e tradutores",
  "filetype_splanguagesandtranslatorlist": "Idiomas e tradutores",
  "spmasterpagescataloglist": "Galeria de Páginas Mestras",
  "filetype_spmasterpagescataloglist": "Galeria de Páginas Mestras",
  "spnocodeworkflowlibrarylist": "Bibliotecas de fluxo de trabalho sem código",
  "filetype_spnocodeworkflowlibrarylist": "Bibliotecas de fluxo de trabalho sem código",
  "spprojecttask": "Tarefa do projeto",
  "filetype_spprojecttask": "Tarefa do projeto",
  "spprojecttasklist": "Tarefas de projeto",
  "filetype_spprojecttasklist": "Tarefas de projeto",
  "sppublishingpageslibrarylist": "Biblioteca de páginas",
  "filetype_sppublishingpageslibrarylist": "Biblioteca de páginas",
  "spreportdocumentlibrarylist": "Biblioteca de documentos de relatório",
  "filetype_spreportdocumentlibrarylist": "Biblioteca de documentos de relatório",
  "spreportlibrarylist": "Biblioteca de relatórios",
  "filetype_spreportlibrarylist": "Biblioteca de relatórios",
  "spslidelibrarylist": "Biblioteca de slides",
  "filetype_spslidelibrarylist": "Biblioteca de slides",
  "sptab": "Guias",
  "filetype_sptab": "Guias",
  "sptablist": "Lista de guias",
  "filetype_sptablist": "Lista de guias",
  "sptranslationmanagementlibrarylist": "Biblioteca de gerenciamento de tradução",
  "filetype_sptranslationmanagementlibrarylist": "Biblioteca de gerenciamento de tradução",
  "spuserinformation": "Informações do usuário",
  "filetype_spuserinformation": "Informações do usuário",
  "spuserinformationlist": "Lista de informações do usuário",
  "filetype_spuserinformationlist": "Lista de informações do usuário",
  "spwikipagelibrarylist": "Biblioteca de páginas wiki",
  "filetype_spwikipagelibrarylist": "Biblioteca de páginas wiki",
  "spworkflowhistory": "Histórico do fluxo de trabalho",
  "filetype_spworkflowhistory": "Histórico do fluxo de trabalho",
  "spworkflowhistorylist": "Lista do histórico do fluxo de trabalho",
  "filetype_spworkflowhistorylist": "Lista do histórico do fluxo de trabalho",
  "spworkflowprocess": "Processo de fluxo de trabalho personalizado",
  "filetype_spworkflowprocess": "Processo de fluxo de trabalho personalizado",
  "spworkflowprocesslist": "Processos de fluxo de trabalho personalizados",
  "filetype_spworkflowprocesslist": "Processos de fluxo de trabalho personalizados",
  "sppublishingimageslibrarylist": "Biblioteca de imagens de publicação",
  "filetype_sppublishingimageslibrarylist": "Biblioteca de imagens de publicação",
  "spcirculation": "Circulação",
  "filetype_spcirculation": "Circulação",
  "spcirculationlist": "Circulações",
  "filetype_spcirculationlist": "Circulações",
  "spdashboardslibrarylist": "Biblioteca de painéis de controle",
  "filetype_spdashboardslibrarylist": "Biblioteca de painéis de controle",
  "spdataconnectionforperformancepointlibrarylist": "Biblioteca de conexões de dados do PerformancePoint",
  "filetype_spdataconnectionforperformancepointlibrarylist": "Biblioteca de conexões de dados do PerformancePoint",
  "sphealthreport": "Relatório de saúde",
  "filetype_sphealthreport": "Relatório de saúde",
  "sphealthreportlist": "Relatórios de saúde",
  "filetype_sphealthreportlist": "Relatórios de saúde",
  "sphealthrule": "Regra de saúde",
  "filetype_sphealthrule": "Regra de saúde",
  "sphealthrulelist": "Regras de saúde",
  "filetype_sphealthrulelist": "Regras de saúde",
  "spimedictionary": "Dicionário IME",
  "filetype_spimedictionary": "Dicionário IME",
  "spimedictionarylist": "Dicionários IME",
  "filetype_spimedictionarylist": "Dicionários IME",
  "spperformancepointcontent": "Conteúdo do PerformancePoint",
  "filetype_spperformancepointcontent": "Conteúdo do PerformancePoint",
  "spperformancepointcontentlist": "Conteúdos do PerformancePoint",
  "filetype_spperformancepointcontentlist": "Conteúdos do PerformancePoint",
  "spphonecallmemo": "Memorando de chamadas telefônicas",
  "filetype_spphonecallmemo": "Memorando de chamadas telefônicas",
  "spphonecallmemolist": "Memorandos de chamadas telefônicas",
  "filetype_spphonecallmemolist": "Memorandos de chamadas telefônicas",
  "sprecordlibrarylist": "Biblioteca de gravações",
  "filetype_sprecordlibrarylist": "Biblioteca de gravações",
  "spresource": "Recurso",
  "filetype_spresource": "Recurso",
  "spresourcelist": "Recursos",
  "filetype_spresourcelist": "Recursos",
  "spprocessdiagramslibrarylist": "Biblioteca de diagramas de processo",
  "filetype_spprocessdiagramslibrarylist": "Biblioteca de diagramas de processo",
  "spsitethemeslibrarylist": "Biblioteca de temas do site",
  "filetype_spsitethemeslibrarylist": "Biblioteca de temas do site",
  "spsolutionslibrarylist": "Biblioteca de soluções",
  "filetype_spsolutionslibrarylist": "Biblioteca de soluções",
  "spwfpublibrarylist": "Biblioteca de WFPUB",
  "filetype_spwfpublibrarylist": "Biblioteca de WFPUB",
  "spwhereabout": "Local",
  "filetype_spwhereabout": "Local",
  "spwhereaboutlist": "Locais",
  "filetype_spwhereaboutlist": "Locais",
  "spdocumentlink": "Link para um documento",
  "filetype_spdocumentlink": "Link para um documento",
  "spdocumentset": "Conjunto de documentos",
  "filetype_spdocumentset": "Conjunto de documentos",
  "spmicrofeedpost": "Postagem de microfeed",
  "filetype_spmicrofeedpost": "Postagem de microfeed",
  "spmicrofeedlist": "Microfeed",
  "filetype_spmicrofeedlist": "Microfeed",
  "splistfolder": "Pasta de lista",
  "filetype_splistfolder": "Pasta de lista",
  "Unknown": "Desconhecido",
  "And": "E",
  "Authenticating": "Autenticando {0} ...",
  "Clear": "Desmarcar {0}",
  "CompleteQuery": "Consulta completa",
  "Exclude": "Excluir {0}",
  "EnterTag": "Adicionar tag",
  "Next": "Próximo",
  "Last": "Último",
  "Link": "Link",
  "Or": "OU",
  "Previous": "Anterior",
  "QueryDidntMatchAnyDocuments": "Sua consulta não encontrou nenhum documento correspondente.",
  "QueryException": "Sua consulta tem um erro: {0}.",
  "Me": "Eu",
  "Remove": "Remover",
  "Search": "Pesquisar",
  "SearchFor": "Pesquisar por {0}",
  "ShareQuery": "Compartilhar consulta",
  "Preferences": "Preferências",
  "LinkOpeningSettings": "Configurações de abertura do link",
  "Reauthenticate": "Reautenticar {0}",
  "ResultsFilteringExpression": "Expressões de filtragem de resultados",
  "FiltersInYourPreferences": "Filtros em suas preferências",
  "Create": "Criar",
  "SearchIn": "Pesquisar em {0}",
  "Seconds": "em {0} segundo<pl>s</pl>",
  "ShowingResultsOf": "Resultado<pl>s</pl> {0}<pl>-{1}</pl> de {2}",
  "ShowingResultsOfWithQuery": "Resultado<pl>s</pl> {0}<pl>-{1}</pl> de {2}",
  "SwitchTo": "Mudar para {0}",
  "Unexclude": "Desfazer exclusão {0}",
  "ClearAllFilters": "Desmarcar todos os filtros",
  "SkipLogin": "Ignorar login",
  "LoginInProgress": "Login em andamento, aguarde ...",
  "Login": "Login",
  "GetStarted": "Introdução",
  "More": "Mais",
  "NMore": "{0} mais...",
  "Less": "Menos",
  "Settings": "Configurações",
  "Score": "Pontuação",
  "ScoreDescription": "A pontuação é calculada a partir do número de ocorrências, bem como a partir da posição no conjunto de resultados.",
  "Occurrences": "Ocorrências",
  "OccurrencesDescription": "Classifica pelo número de ocorrências, com valores que têm o maior número aparecendo em primeiro lugar.",
  "Label": "Rótulo",
  "Of": "de",
  "LabelDescription": "Classifica os valores do campo em ordem alfabética.",
  "Value": "Valor",
  "ValueDescription": "Classifica os valores do primeiro campo calculado",
  "AlphaAscending": "Valor crescente",
  "AlphaDescending": "Valor decrescente",
  "ChiSquare": "Qui-quadrado",
  "Nosort": "Sem classificação",
  "NosortDescription": "Não classificar os valores. Os valores serão retornados em uma ordem aleatória.",
  "RelativeFrequency": "Frequência relativa",
  "RelativeFrequencyDescription": "Classifica com base na frequência relativa dos valores. Valores menos comuns aparecerão mais altos.",
  "DateDistribution": "Distribuição de data",
  "Custom": "Personalizada",
  "CustomDescription": "Classifica com base em uma ordem personalizada",
  "ComputedField": "Campo calculado",
  "Ascending": "Crescente",
  "Descending": "Decrescente",
  "noResultFor": "Nenhum resultado para {0}",
  "autoCorrectedQueryTo": "A consulta foi corrigida automaticamente para {0}",
  "didYouMean": "Você quis dizer: {0}",
  "SuggestedResults": "Resultados sugeridos",
  "SuggestedQueries": "Consultas sugeridas",
  "MostRelevantItems": "Itens mais relevantes:",
  "AllItems": "Todos os itens:",
  "ShowLess": "Mostrar menos",
  "ShowMore": "Mostrar mais",
  "HideFacet": "Ocultar faceta",
  "ShowFacet": "Mostrar faceta",
  "AndOthers": "e {0} outro<pl>s</pl>",
  "Others": "{0} outro<pl>s</pl>",
  "MostRelevantPosts": "Postagens mais relevantes:",
  "CompleteThread": "Tópico completo:",
  "ShowCompleteThread": "Mostrar o tópico completo",
  "ShowOnlyTopMatchingPosts": "Mostrar somente as principais postagens correspondentes",
  "MostRelevantReplies": "Respostas mais relevantes:",
  "AllConversation": "Todas as conversas:",
  "ShowAllConversation": "Mostrar todas as conversas",
  "ShowAllReplies": "Mostrar todas as respostas",
  "ShowOnlyMostRelevantReplies": "Mostrar somente as respostas mais relevantes",
  "Close": "Fechar",
  "Open": "Abrir",
  "OpenInOutlookWhenPossible": "Abrir no Outlook (quando possível)",
  "AlwaysOpenInNewWindow": "Sempre abrir os resultados em uma nova janela",
  "Quickview": "Visualização rápida",
  "NoQuickview": "A Visualização rápida para este documento não está disponível",
  "ErrorReport": "Relatório de erros",
  "OopsError": "Algo deu errado no servidor.",
  "ProblemPersists": "Se o problema persistir entre em contato com o administrador.",
  "GoBack": "Voltar",
  "Reset": "Reiniciar",
  "Retry": "Tentar novamente",
  "MoreInfo": "Mais Informações",
  "Username": "Nome de usuário",
  "Password": "Senha",
  "PostedBy": "Postado por",
  "CannotConnect": "Não é possível conectar ao endereço do servidor.",
  "BadUserPass": "Nome de usuário e senha não correspondem.",
  "PleaseEnterYourCredentials": "Digite as suas credenciais para {0}.",
  "PleaseEnterYourSearchPage": "Digite a URL da página de pesquisa",
  "Collapse": "Recolher",
  "Collapsable": "Recolhível",
  "Expand": "Expandir",
  "Today": "Hoje",
  "Yesterday": "Ontem",
  "Tomorrow": "Amanhã",
  "Duration": "Duração: {0}",
  "IndexDuration": "Duração do índice: {0}",
  "ProxyDuration": "Duração do proxy: {0}",
  "ClientDuration": "Duração do cliente: {0}",
  "Unavailable": "Indisponível",
  "Reply": "Responder",
  "ReplyAll": "Responder a todos",
  "Forward": "Encaminhar",
  "From": "De",
  "Caption": "Legenda",
  "Expression": "Expressão",
  "Tab": "Guia",
  "Tabs": "Guias",
  "EnterExpressionName": "Digite o nome da expressão",
  "EnterExpressionToFilterWith": "Digite a expressão para filtrar os resultados",
  "SelectTab": "Selecionar guia",
  "SelectAll": "Selecionar tudo",
  "PageUrl": "URL da página de pesquisa",
  "ErrorSavingToDevice": "Erro ao salvar as informações para o seu dispositivo",
  "ErrorReadingFromDevice": "Erro ao ler as informações do seu dispositivo",
  "AppIntro": "Fale com um especialista de produto que possa responder suas dúvidas sobre a Coveo e ajudá-lo a decidir qual solução Coveo é adequada para você. Ou experimente uma demonstração ao vivo!",
  "TryDemo": "Experimente a demonstração",
  "ContactUs": "Entre em contato conosco",
  "NewToCoveo": "Novo para a Coveo?",
  "LetUsHelpGetStarted": "Vamos ajudá-lo a começar",
  "LikesThis": "{0} assim<sn>s</sn>.",
  "CannotConnectSearchPage": "Não é possível conectar à sua página de pesquisa",
  "AreYouSureDeleteFilter": "Você tem certeza que deseja excluir o filtro {0} com a expressão {1}",
  "OnlineHelp": "Ajuda online",
  "Done": "Concluído",
  "SaveFacetState": "Salvar este estado da faceta",
  "ClearFacetState": "Desmarcar estado da faceta",
  "DisplayingTheOnlyMessage": "Exibindo a única mensagem nesta conversa",
  "NoNetworkConnection": "Sem conexão de rede",
  "UnknownConnection": "Conexão desconhecida",
  "EthernetConnection": "Conexão de Ethernet",
  "WiFi": "Conexão de Wi-fi",
  "CELL": "Conexão de celular",
  "CELL_2G": "Conexão de celular 2G",
  "CELL_3G": "Conexão de celular 3G",
  "CELL_4G": "Conexão de celular 4G",
  "Relevance": "Relevância",
  "Date": "Data",
  "Amount": "Quantidade",
  "QueryExceptionNoException": "Sem exceção",
  "QueryExceptionInvalidSyntax": "Sintaxe inválida",
  "QueryExceptionInvalidCustomField": "Campo personalizado inválido",
  "QueryExceptionInvalidDate": "Data inválida",
  "QueryExceptionInvalidExactPhrase": "Frase exata inválida",
  "QueryExceptionInvalidDateOp": "Operador de data inválido",
  "QueryExceptionInvalidNear": "Operador NEAR inválido",
  "QueryExceptionInvalidWeightedNear": "NEAR ponderado inválido",
  "QueryExceptionInvalidTerm": "Termo inválido",
  "QueryExceptionTooManyTerms": "Muitos termos",
  "QueryExceptionWildcardTooGeneral": "Caractere curinga muito geral",
  "QueryExceptionInvalidSortField": "Campo de classificação inválido",
  "QueryExceptionInvalidSmallStringOp": "Operador de pequena cadeia de caracteres inválido",
  "QueryExceptionRequestedResultsMax": "Resultados máximos solicitados",
  "QueryExceptionAggregatedMirrorDead": "O espelho agregado está offline",
  "QueryExceptionAggregatedMirrorQueryTimeOut": "Tempo limite da consulta do espelho agregado",
  "QueryExceptionAggregatedMirrorInvalidBuildNumber": "Número de compilação inválido do espelho agregado",
  "QueryExceptionAggregatedMirrorCannotConnect": "Espelho agregado não pode se conectar",
  "QueryExceptionNotEnoughLeadingCharsWildcard": "Caractere curinga líder insuficiente",
  "QueryExceptionSecurityInverterNotFound": "Inversor de segurança não encontrado",
  "QueryExceptionSecurityInverterAccessDenied": "Acesso ao inversor de segurança negado",
  "QueryExceptionAggregatedMirrorCannotImpersonate": "O espelho agregado não pode representar",
  "QueryExceptionUnexpected": "Inesperado",
  "QueryExceptionAccessDenied": "Acesso negado",
  "QueryExceptionSuperUserTokenInvalid": "Token de superusuário inválido",
  "QueryExceptionSuperUserTokenExpired": "Token de superusuário expirado",
  "QueryExceptionLicenseQueriesExpired": "Consultas de licença expiradas",
  "QueryExceptionLicenseSuperUserTokenNotSupported": "Licença de token de superusuário não suportada",
  "QueryExceptionInvalidSession": "Sessão inválida",
  "QueryExceptionInvalidDocument": "Documento inválido",
  "QueryExceptionSearchDisabled": "Pesquisa desativada",
  "FileType": "Tipo de arquivo",
  "ShowAttachment": "Mostrar anexo",
  "OnFeed": "no feed de {0} .",
  "Author": "Autor",
  "NoTitle": "Sem título",
  "CurrentSelections": "Seleções atuais",
  "AllContent": "Todo o conteúdo",
  "CancelLastAction": "Cancelar a última ação",
  "SearchTips": "Dicas de pesquisa",
  "CheckSpelling": "Verifique a ortografia das suas palavras-chave.",
  "TryUsingFewerKeywords": "Tente usar palavras-chave menores, diferentes ou mais simples.",
  "SelectFewerFilters": "Selecione filtros menores para ampliar a sua pesquisa.",
  "Document": "Documento",
  "Time": "Hora",
  "StartDate": "Data de início",
  "StartTime": "Hora de início",
  "DurationTitle": "Duração",
  "UserQuery": "Consulta do usuário",
  "ShowUserActions": "Mostrar as ações do usuário",
  "NoData": "Nenhum dado disponível",
  "EventType": "Tipo de evento",
  "GoToFullSearch": "Pesquisa completa",
  "GoToEdition": "Painel de personalização",
  "RemoveContext": "Remover contexto",
  "BoxAttachToCase": "Anexar ao caso",
  "AttachToCase": "Anexar ao caso",
  "Attach": "Anexar",
  "Attached": "Anexado",
  "Detach": "Desanexar",
  "Details": "Detalhes",
  "AdditionalFilters": "Filtros adicionais",
  "SelectNonContextualSearch": "Remova o contexto do registro atual para ampliar a sua pesquisa",
  "CopyPasteToSupport": "Copie e cole esta mensagem para a equipe de Suporte da Coveo para obter mais informações.",
  "FollowQueryDescription": "Alerte-me quando ocorrer alterações nos resultados da pesquisa desta consulta.",
  "SearchAlerts_Panel": "Gerenciar alertas",
  "SearchAlerts_PanelDescription": "Visualizar e gerenciar os seus alertas de pesquisa.",
  "SearchAlerts_PanelNoSearchAlerts": "Você não possui assinaturas.",
  "SearchAlerts_Fail": "O serviço de Pesquisa de alertas não está disponível no momento.",
  "SearchAlerts_Type": "Tipo",
  "SearchAlerts_Content": "Conteúdo",
  "SearchAlerts_Actions": "Ação",
  "EmptyQuery": "<vazio>",
  "SearchAlerts_Type_followQuery": "Consulta",
  "SearchAlerts_Type_followDocument": "Item",
  "SearchAlerts_unFollowing": "Parar de seguir",
  "SearchAlerts_follow": "Seguir",
  "SearchAlerts_followed": "Seguido",
  "SearchAlerts_followQuery": "Seguir consulta",
  "Subscription_StopFollowingQuery": "Parar de seguir a consulta",
  "SearchAlerts_Frequency": "Quando",
  "SubscriptionsManageSubscriptions": "Gerenciar alertas",
  "SubscriptionsMessageFollowQuery": "Você receberá alertas quando a consulta <b>{0}</b> retornar itens novos ou atualizados.",
  "SubscriptionsMessageFollow": "Você receberá alertas se ocorrer alterações no item <b>{0}</b>.",
  "Expiration": "Expiração",
  "Monthly": "Mensal",
  "Daily": "Diário",
  "Monday": "Segunda-feira",
  "Tuesday": "Terça-feira",
  "Wednesday": "Quarta-feira",
  "Thursday": "Quinta-feira",
  "Friday": "Sexta-feira",
  "Saturday": "Sábado",
  "Sunday": "Domingo",
  "NextDay": "Próximo(a) {0}",
  "LastDay": "Último(a) {0}",
  "StartTypingCaseForSuggestions": "Descreva o seu problema para ver as possíveis soluções",
  "ExportToExcel": "Exportar para o Excel",
  "ExportToExcelDescription": "Exportar os resultados da pesquisa para o Excel",
  "CaseCreationNoResults": "Nenhuma solução recomendada foi encontrada",
  "SortBy": "Classificar por",
  "BoxCreateArticle": "Criar artigo",
  "Facets": "Facetas",
  "AdvancedSearch": "Pesquisa avançada",
  "Keywords": "Palavras-chave",
  "AllTheseWords": "Todas essas palavras",
  "ExactPhrase": "Esta frase exata",
  "AnyOfTheseWords": "Qualquer uma dessas palavras",
  "NoneOfTheseWords": "Nenhuma dessas palavras",
  "Anytime": "A qualquer momento",
  "InTheLast": "Nos últimos",
  "Days": "dias",
  "Months": "meses",
  "Month": "Mês",
  "Year": "Ano",
  "Between": "Entre",
  "Language": "Idioma",
  "Size": "Tamanho",
  "AtLeast": "pelo menos",
  "AtMost": "no máximo",
  "Contains": "contém",
  "DoesNotContain": "não contém",
  "Matches": "coincidências",
  "Bytes": "bytes",
  "card": "Cartão",
  "table": "Tabela",
  "ResultLinks": "Links do resultado",
  "EnableQuerySyntax": "Habilitar a sintaxe da consulta",
  "On": "Ativar",
  "Off": "Desativar",
  "Automatic": "Automático",
  "ResultsPerPage": "Resultados por página",
  "PreviousMonth": "Mês anterior",
  "NextMonth": "Próximo mês",
  "Title": "Título",
}

  var locales = String["locales"] || (String["locales"] = {});
  locales["pt-BR"] = merge(locales["pt-BR"], dict);
  String["toLocaleString"].call(this, { "pt-BR": dict });
  String["locale"] = "pt-BR";
  String["defaultLocale"] = "en";
  Globalize.culture("pt-BR")
}